/* ****************************************************************************
 * Copyright: 2017-2025 RAYLASE GmbH
 * This source code is the proprietary confidential property of RAYLASE GmbH.
 * Reproduction, publication, or any form of distribution to
 * any party other than the licensee is strictly prohibited.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#ifndef RLTB_API_H_
#define RLTB_API_H_

#include <stddef.h>
#include <stdint.h>
#include <time.h>

#ifdef _WIN32
	#ifdef RLTB_COMPILING_DLL
		#define RLTB_API __declspec(dllexport)
	#else
		#define RLTB_API __declspec(dllimport)
	#endif
#elif defined(__GNUC__) || defined(__clang__)
	#define RLTB_API __attribute__((visibility("default")))
#else
	#define RLTB_API
#endif
#ifdef __cplusplus
	#define RLTB_C_API extern "C" RLTB_API
#else
	#define RLTB_C_API RLTB_API
#endif

RLTB_C_API void rltbGetLastError(char* buffer, int32_t bufferSize);
RLTB_C_API int32_t rltbGetLastErrorLen(void);

#endif